% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_shinyOAuth.R
\name{use_shinyOAuth}
\alias{use_shinyOAuth}
\title{Add JavaScript dependency to the UI of a Shiny app}
\usage{
use_shinyOAuth()
}
\value{
A tagList containing a singleton dependency tag that ensures the JS
file \code{inst/www/shinyOAuth.js} is loaded
}
\description{
Adds the package's client-side JavaScript helpers as an htmlDependency to
your Shiny UI. This enables features such as redirection and setting
the browser cookie token.

Without adding this to the UI of your app,  the \code{oauth_module_server()} will not function.
}
\details{
Place this near the top-level of your UI (e.g., inside \code{fluidPage()} or
\code{tagList()}), similar to how you would use \code{shinyjs::useShinyjs()}.
}
\examples{
ui <- shiny::fluidPage(
  use_shinyOAuth(),
  # ...
)

}
\seealso{
\code{\link[=oauth_module_server]{oauth_module_server()}}
}
