% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_sig_reg.r
\name{call_fdr}
\alias{call_fdr}
\title{call_fdr}
\usage{
call_fdr(whole_re, thres_tr = 10, method = 'BH')
}
\arguments{
\item{whole_re}{A list of the objects obtained from sharpr2 for each chromosome.}

\item{thres_tr}{The threshold for the size of tiled reigons used for calculate FDR-adjusted p-values. The default value is 10.}

\item{method}{The method for calculating FDR-adjusted p-values. See the function 'p.adjust' for more details abount the method. The default is 'BH'.}

}
\value{
gfdr: a result table (data.frame) containing FDR-adjusted p-values, chromosome, region, the size and the index of the tiled region it is located.

}
\description{
Calculate FDR-adjusted p-values.
}
\examples{

\donttest{
data(hidra_ex)
whole_re <- sharpr2(hidra_ex, l_min = 150, l_max = 600, f_dna = 5, f_rna = 0, sig=FALSE)
call_fdr(list(whole_re))
}

}
\keyword{HiDRA}
\keyword{sharpr2}
