% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implied_scores.R
\name{implied_scores}
\alias{implied_scores}
\title{Implied Scores of Observed Outcome Variables}
\usage{
implied_scores(fit)
}
\arguments{
\item{fit}{The output from \code{\link[lavaan:lavaan]{lavaan::lavaan()}}, such as \code{\link[lavaan:cfa]{lavaan::cfa()}}
and \code{\link[lavaan:sem]{lavaan::sem()}}.}
}
\value{
A matrix of the implied scores.
}
\description{
Gets a \code{\link[lavaan:lavaan]{lavaan::lavaan()}} output and computes the
implied scores of observed outcome variables.
}
\details{
The implied scores for each observed outcome variable
(the \code{y}-variables or the endogenous variables) are
simply computed in the same way the predicted scores in a linear
regression model are computed.

Currently it supports only single-group path analysis models with only
observed variables.
}
\examples{
library(lavaan)
dat <- pa_dat
# For illustration, select only the first 50 cases
dat <- dat[1:50, ]
# The model
mod <-
"
m1 ~ iv1 + iv2
dv ~ m1
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# Compute the implied scores for `m1` and `dv`
fit_implied_scores <- implied_scores(fit)
head(fit_implied_scores)


}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
