% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/selfea.R
\name{ttest_cohens_d}
\alias{ttest_cohens_d}
\title{ttest_cohens_d}
\usage{
ttest_cohens_d(values, groups, alpha = 0.05, power = 0.9,
  alternative = "two.sided", paired = FALSE, var.equal = FALSE)
}
\arguments{
\item{values}{A scalar vector.  Length of both of two vectors, values and groups, should be same.}

\item{groups}{Experiment groups for the vector 'values'. Length of both of two vectors, values and groups, should be same.
The number of groups is not limited to two, such as group <- c('A','A','A','B','B').}

\item{alpha}{P-value threshold}

\item{power}{Give the statistical power you desired for output significant list}

\item{alternative}{Choose one of these c("two.sided", "less", "greater"). Default is "two.sided".}

\item{paired}{if two groups are paired, set it to TRUE.  Default is FALSE.}

\item{var.equal}{if two groups are assumed to have same variance, set it to TRUE.  Default is FALSE.}
}
\value{
A list containing the followings:
   \tabular{ll}{
   observed_pvalue \tab Calculated P-value from T-test \cr
   observed_cohens_d \tab Calculated Cohen's f\cr
   threshold_cohens_d \tab Cohen's d threshold at the desired power\cr
   threshold_pvalue \tab Desired p-value threshold\cr
   flag_pvalue \tab TRUE=passed the pvalue threshold, FALSE=not\cr
   flag_cohens_d \tab TRUE=passed the Cohen's d threshold, FALSE=not \cr
   power_desired \tab Statistical power in you input parameters \cr
   method \tab 'Welch Two Sample t-test' \cr
   alternative \tab alternative option in you input parameters \cr
   paired \tab paired option in you input parameters \cr
   var.equal \tab var.equal option in you input parameters \cr
   }
}
\description{
Fulfill Welch Two Sample t-test (\code{\link{t.test}}) and calculate Cohen's d as well as determine significance by p-value and effect size threshold.
}
\examples{
library(selfea)

values <- c(8,10,8,8,11,29,26,22,27,26)
groups <- c("U200","U200","U200","U200","U200","U600","U600","U600","U600","U600")
list_result <- ttest_cohens_d (values, groups, 0.05, 0.90)
}

