% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-funs.R
\name{date}
\alias{date}
\alias{date_create}
\alias{date_create_}
\alias{date_missing}
\alias{date_standardize}
\title{Date based cleaning}
\usage{
date_standardize(x, format = "\%Y-\%m-\%d", date_column = "date", ...)

date_missing(x, date_column = "date", drop = TRUE, ...)

date_create(x, ...)

date_create_(x, ..., .dots, format = "\%Y-\%m-\%d", date_column = "date")
}
\arguments{
\item{x}{(data.frame) A data.frame}

\item{format}{(character) Date format. See \code{\link{as.Date}}}

\item{date_column}{(character) Name of the date column}

\item{...}{Comma separated list of unquoted variable names}

\item{drop}{(logical) Drop bad data points or not. Either way, we parse
out bade data points as an attribute you can access. Default: \code{TRUE}}

\item{.dots}{Used to work around non-standard evaluation}
}
\value{
Returns a data.frame, with attributes
}
\description{
Date based cleaning
}
\details{
\itemize{
 \item date_standardize - Converts dates to a specific format
 \item date_missing - Drops records that do not have dates, either via being
 NA or being a zero length character string
 \item date_create - Create a date field from
}
}
\examples{
df <- sample_data_1
# Standardize dates
dframe(df) \%>\% date_standardize()
dframe(df) \%>\% date_standardize("\%Y/\%m/\%d")
dframe(df) \%>\% date_standardize("\%d\%b\%Y")
dframe(df) \%>\% date_standardize("\%Y")
dframe(df) \%>\% date_standardize("\%y")

# drop records without dates
NROW(df)
NROW(dframe(df) \%>\% date_missing())

# Create date field from other fields
df <- sample_data_2
## NSE
dframe(df) \%>\% date_create(year, month, day)
## SE
date_create_(dframe(df), "year", "month", "day")
}

