% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeSmet.R
\name{writeSmet}
\alias{writeSmet}
\title{Write a SMET file}
\usage{
writeSmet(smet, filename)
}
\arguments{
\item{smet}{A data structure that resembles a smet file (i.e., list containing metadata and a
data.frame, see example in \link{readSmet})}

\item{filename}{Filepath to be written}
}
\value{
Generates smet file
}
\description{
Write data into a SMET file https://models.slf.ch/docserver/meteoio/SMET_specifications.pdf
}
\examples{
## First read example smet file provided in package
(Wx = readSmet(system.file('extdata', 'example.smet', package = 'sarp.snowprofile')))

## Then write Wx to a new temp file and show the file
writeSmet(Wx, filename = file.path(tempdir(), 'file.smet'))
file.show(file.path(tempdir(), 'file.smet'))

## Check whether it can be read back in
(WxNew <- readSmet(file.path(tempdir(), 'file.smet')))

}
\seealso{
\link{readSmet}, \link{snowprofileSno}, \link{snowprofilePrf}, \link{snowprofilePro}
}
\author{
fherla, shorton
}
