% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampleSPpairs.R
\name{resampleSPpairs}
\alias{resampleSPpairs}
\title{Resample a pair of profiles}
\usage{
resampleSPpairs(
  query,
  ref,
  mergeBeforeResampling = FALSE,
  dims = c("gtype", "hardness")
)
}
\arguments{
\item{query}{query snowprofile or snowprofileLayers object}

\item{ref}{reference snowprofile or snowprofileLayers object}

\item{mergeBeforeResampling}{shall adjacent layers with identical layer properties be merged? (boolean)}

\item{dims}{layer properties to consider for a potential merging}
}
\value{
a list with the resampled input objects under the entries \code{query} and \code{ref}.
}
\description{
Resample a pair of (irregularly layered) profiles onto the smallest common height grid. To reduce data storage
this routine can be used to merge layers based on specified layer properties, if the input profiles
have been resampled earlier, or if due to other reasons existing layers in the individual profiles can be merged.
In summary, this routine alters how the layer information of snow profiles is \emph{stored} without changing how the
profiles appear.
}
\details{
The smallest common height grid is found by
\enumerate{
\item extract all unique layer interfaces in both profiles
\item resample each profile with the above height grid, \cr
(!) but set all height values that exceed each max snow height to that max snow height!
}
}
\examples{

## initial situation before mutual resampling:
## two profiles with different snow heights and different numbers of layers
summary(SPpairs$A_manual)[, c("hs", "nLayers")]
summary(SPpairs$A_modeled)[, c("hs", "nLayers")]
opar <- par(no.readonly=TRUE)
par(mfrow = c(1, 2))
plot(SPpairs$A_manual, main = "Initial profiles before resampling",
     ylab = "Snow height", ymax = 272)
plot(SPpairs$A_modeled, ylab = "Snow height", ymax = 272)

## resampling:
resampledSPlist <- resampleSPpairs(SPpairs$A_manual, SPpairs$A_modeled,
                                   mergeBeforeResampling = TRUE)

## two profiles with different snow heights and IDENTICAL numbers of layers
summary(resampledSPlist$query)[, c("hs", "nLayers")]
summary(resampledSPlist$ref)[, c("hs", "nLayers")]
plot(resampledSPlist$query, main = "Profiles after resampling",
     ylab = "Snow height", ymax = 272)
plot(resampledSPlist$ref, ylab = "Snow height", ymax = 272)
par(opar)

}
\seealso{
\link{resampleSP}, \link{mergeIdentLayers}
}
\author{
fherla
}
