% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2polygon.R
\name{S2Polygon}
\alias{S2Polygon}
\title{Construct a S2Polygon}
\usage{
S2Polygon(x, validate = TRUE, xor_edges = TRUE,
  vertex_merge_radius = 0, edge_splice_fraction = 0.866,
  undirected_edges = FALSE)
}
\arguments{
\item{x}{Input to construct the polygon from. At the moment the only valid
input is a list of loops.}

\item{validate}{Logical to validate the S2Polygon. Default is `TRUE`.}

\item{xor_edges}{Logical to indicate that edges should be 'xor'ed to avoind
multiple loops with common edges. Default is `TRUE`.}

\item{vertex_merge_radius}{Numeric indicating that vertices within this
distance should be merged. Defaults to zero (i.e. no merging).}

\item{edge_splice_fraction}{Determines when edges are spliced. See C++
header as indicated in the description of this function. Default is 0.866.}

\item{undirected_edges}{Logical to indicate that input edges should be
considered undirected.  Default is `FALSE`.
multiple loops with common edges. Default is `TRUE`.}
}
\description{
This function builds an `S2Polygon` using the C++ polygon builder. See the
header file inst/include/s2/s2polygonbuilder.h for details on how to use the
arguments.
}
