# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title
#' cell_center
#' @description
#' Get center of S2 cell containing a specified point
#' 
#' @param lat latitude of interest (between -90 and +90)
#' 
#' @param lng longitude of interest (between -180 and +180)
#' 
#' @details
#' \code{cell_center} takes a single (lat,lng) point on the sphere, finds the
#' S2 leaf cell that contains this point and returns the center of this cell.
#' In S2 leaf cells have a very fine resolution, so the output is expected to
#' be very close to the input, and differences are typically on something like
#' the 5th decimal place.
#' 
#' @examples
#' cell_center(57.0139595, 9.988967)
#' 
#' @export
cell_center <- function(lat, lng) {
    .Call('s2_cell_center', PACKAGE = 's2', lat, lng)
}

