% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_small_components.R
\name{remove_small_components}
\alias{remove_small_components}
\title{Remove small components}
\usage{
remove_small_components(g)
}
\arguments{
\item{g}{An igraph object of the graph to embed.}
}
\value{
An igraph object.
}
\description{
keep only the largest component of graph
}
\details{
As setse only works on connected components this function removes all but the largest component. 
This is a helper function to quickly project a network with setse.
}
\examples{
library(igraph)
set.seed(1284)
#generate a random erdos renyi graph with 100 nodes and 150 edges
g <- erdos.renyi.game(n=100, p.or.m = 150, type = "gnm" )
#count the number of components
components(g)$no

#remove all but the largest component
g2 <-remove_small_components(g)

#Now there is only 1 component
igraph::components(g2)$no

}
