% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRepast.R
\name{Model}
\alias{Model}
\title{The easy API for model initilization}
\usage{
Model(modeldir = "", maxtime = 300, dataset = "none", load = FALSE)
}
\arguments{
\item{modeldir}{The installation directory of some repast model}

\item{maxtime}{The total simulated time}

\item{dataset}{The name of any model aggregate dataset}

\item{load}{If true instantiate model and load scenario}
}
\value{
Returns the instance of repast model
}
\description{
Instantiate a repast model from the model dir without
loading the scenario file.
}
\details{
This is the entry point for model execution. Typically 
any model execution will start with this function which encapsulates 
all low level calls for model initialization. In order to perform 
simulations with repast from R code only \code{Model} and a 
few more function calls are required: \code{\link{Load}}, 
\code{\link{Run}}. Finally the output of model is managed with 
functions \code{\link{GetResults}} and \code{\link{SaveSimulationData}}.
}
\examples{
\dontrun{
   d<- "C:/usr/models/your-model-directory"
   m<- Model(d)}
   
}
\references{
[1] North, M.J., N.T. Collier, and J.R. Vos, "Experiences Creating Three Implementations of the Repast Agent Modeling Toolkit," ACM Transactions
on Modeling and Computer Simulation, Vol. 16, Issue 1, pp. 1-25, ACM,
New York, New York, USA (January 2006).
}

