% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxigraph-package.R
\docType{package}
\name{roxigraph-package}
\alias{roxigraph}
\alias{roxigraph-package}
\title{roxigraph: RDF and SPARQL for R}
\description{
Provides RDF storage and SPARQL 1.1 query capabilities by wrapping the
'Oxigraph' graph database library. Supports in-memory and persistent ('RocksDB')
storage, multiple RDF serialization formats, and full SPARQL 1.1 Query and
Update support.
}
\section{Main Functions}{

\itemize{
\item \code{\link{rdf_store}}: Create an RDF store
\item \code{\link{rdf_load}}: Load RDF data
\item \code{\link{sparql_query}}: Execute SPARQL queries
\item \code{\link{sparql_update}}: Execute SPARQL updates
\item \code{\link{rdf_serialize}}: Serialize RDF data
}
}

\seealso{
Useful links:
\itemize{
\item \url{https://github.com/cboettig/roxigraph}
\item \url{https://github.com/oxigraph/oxigraph}
\item Report bugs at \url{https://github.com/cboettig/roxigraph/issues}
}
}
\author{
\strong{Maintainer}: Carl Boettiger \email{cboettig@gmail.com} (\href{https://orcid.org/0000-0002-1642-628X}{ORCID})

Authors:
\itemize{
  \item Authors of the dependency Rust crates (see inst/AUTHORS file)
}

Other contributors:
\itemize{
  \item Oxigraph Contributors (Oxigraph Rust library) [copyright holder]
}

}
\keyword{internal}
