% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy_mrca}
\alias{flags.taxon_mrca}
\alias{is_suppressed.taxon_mrca}
\alias{ott_id.taxon_mrca}
\alias{tax_name.taxon_mrca}
\alias{tax_rank.taxon_mrca}
\alias{tax_sources.taxon_mrca}
\alias{taxonomy_mrca}
\alias{unique_name.taxon_mrca}
\title{Taxonomic MRCA}
\usage{
taxonomy_mrca(ott_ids = NULL, ...)

\method{tax_rank}{taxon_mrca}(tax, ...)

\method{tax_name}{taxon_mrca}(tax, ...)

\method{ott_id}{taxon_mrca}(tax, ...)

\method{unique_name}{taxon_mrca}(tax, ...)

\method{tax_sources}{taxon_mrca}(tax, ...)

\method{flags}{taxon_mrca}(tax, ...)

\method{is_suppressed}{taxon_mrca}(tax, ...)
}
\arguments{
\item{ott_ids}{a vector of ott ids for the taxa whose MRCA is to
be found (numeric).}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}

\item{tax}{an object generated by the \code{taxonomy_mrca}
function}
}
\value{
\itemize{

    \item{\code{taxonomy_mrca}} { returns a list about the
    taxonomic information relating to the MRCA for the ott_ids
    provided. }

    \item{\code{tax_rank}} { returns a character vector of the
    taxonomic rank for the MRCA. }

    \item{\code{tax_name}} { returns a character vector the
    Open Tree Taxonomy name for the MRCA. }

    \item{\code{ott_id}} { returns a numeric vector of the ott id
    for the MRCA. }

}
}
\description{
Taxonomic Least Inclusive Common Ancestor (MRCA)
}
\details{
Given a set of OTT ids, get the taxon that is the most recent common
ancestor (the MRCA) of all the identified taxa.
}
\examples{
\dontrun{
req <- taxonomy_mrca(ott_ids=c(515698,590452,643717))
tax_rank(req)
tax_name(req)
ott_id(req)
}
}

