fetch_ggproto <- function(x, name) {
  res <- NULL

  val <- .subset2(x, name)
  if (!is.null(val) || (is.environment(x) && exists(name, envir = x, inherits = FALSE))) {
    res <- val
  } else {
    super <- .subset2(x, "super")
    if (is.null(super)) {
      # no super class
    } else if (is.function(super)) {
      res <- fetch_ggproto(super(), name)
    } else {
      cli::cli_abort(c(
        "{class(x)[[1]]} was built with an incompatible version of ggproto.",
        "i" = "Please reinstall the package that provides this extension."
      ))
    }
  }

  res
}


#' @export
#' @noRd
`$.ggproto` <- function(x, name) {
  res <- fetch_ggproto(x, name)
  if (!is.function(res)) {
    return(res)
  }

  make_proto_method(x, res, name)
}


make_proto_method <- function(self, f, name) {
  args <- formals(f)
  has_self <- !is.null(args[["self"]]) || "self" %in% names(args)

  assign(name, f, envir = environment())
  args <- list(quote(...))
  if (has_self) {
    args$self <- quote(self)
  }
  fun <- rlang::inject(function(...) !!rlang::call2(name, !!!args))

  class(fun) <- "ggproto_method"
  fun
}

