% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.Delta14C}
\alias{draw.Delta14C}
\title{Draw Delta14C and the calibration curve.}
\usage{
draw.Delta14C(
  cal1 = c(),
  cal2 = c(),
  cc = rintcal::ccurve(),
  BCAD = FALSE,
  mar = c(4, 4, 1, 4),
  mgp = c(2.5, 1, 0),
  xaxs = "r",
  yaxs = "r",
  bty = "u",
  ka = FALSE,
  cal.lab = c(),
  cal.rev = FALSE,
  C14.lab = c(),
  C14.lim = c(),
  cc.col = rgb(0, 0.5, 0, 0.5),
  cc.border = rgb(0, 0.5, 0, 0.5),
  Delta14C.lab = c(),
  Delta14C.lim = c(),
  Delta14C.col = rgb(0, 0, 1, 0.5),
  Delta14C.border = rgb(0, 0, 1, 0.5)
)
}
\arguments{
\item{cal1}{First calendar year for the plot. Defaults to youngest calendar age of the calibration curve}

\item{cal2}{Last calendar year for the plot. Defaults to oldest calendar age of the calibration curve}

\item{cc}{The calibration curve to use. Defaults to IntCal20}

\item{BCAD}{The calendar scale of graphs and age output-files is in cal BP (calendar or calibrated years before the present, where the present is AD 1950) by default, but can be changed to cal BC/AD using \code{BCAD=TRUE}.}

\item{mar}{Plot margins (amount of white space along edges of axes 1-4).}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted).}

\item{xaxs}{Whether or not to extend the limits of the horizontal axis. Defaults to \code{xaxs="r"} which extends it by R's default.}

\item{yaxs}{Whether or not to extend the limits of the vertical axis. Defaults to \code{yaxs="r"} which extends it by R's default.}

\item{bty}{Draw a box around the graph ("n" for none, and "l", "7", "c", "u", "]" or "o" for correspondingly shaped boxes).}

\item{ka}{Use kcal BP (and C14 kBP). Defaults to FALSE.}

\item{cal.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}), or to \code{age.lab="kcal BP"} etc. if ka=TRUE.}

\item{cal.rev}{Reverse the calendar axis (defaults to FALSE).}

\item{C14.lab}{Label for the C-14 axis. Defaults to 14C BP (or 14C kBP if ka=TRUE).}

\item{C14.lim}{Limits for the C-14 axis. Calculated automatically by default.}

\item{cc.col}{Colour of the calibration curve (fill).}

\item{cc.border}{Colour of the calibration curve (border).}

\item{Delta14C.lab}{Label for the Delta14C axis.}

\item{Delta14C.lim}{Axis limits for the Delta14C axis. Calculated automatically by default.}

\item{Delta14C.col}{Colour of the Delta14C curve (fill).}

\item{Delta14C.border}{Colour of the Delta14C curve (border).}
}
\value{
A plot of Delta14C and the calibration curve
}
\description{
Draw a proxy of the atmospheric 14C concentration (Delta14C) as well as the calibration curve.
}
\examples{
  draw.Delta14C()
  draw.Delta14C(30e3, 55e3, ka=TRUE)
  draw.Delta14C(cc=rintcal::ccurve("NH1_monthly"), BCAD=TRUE)
}
