% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNull.R
\name{plotNull}
\alias{plotNull}
\title{Plot Random Forest Importance Null Distributions}
\usage{
plotNull(x, preds = NULL, imp.type = NULL, scale = TRUE,
  plot.type = c("density", "hist"), plot = TRUE)
}
\arguments{
\item{x}{An object produced by a call to \code{\link{rfPermute}}.}

\item{preds}{a character vector of predictors to plot. If \code{NULL}, then 
all predictors are plotted.}

\item{imp.type}{Either a numeric or character vector giving the 
importance metric(s) to plot.}

\item{scale}{Plot importance measures scaled (divided by) standard errors?}

\item{plot.type}{type of plot to produce: \code{"density"} for smoothed density 
plot, or \code{"hist"} for histogram.}

\item{plot}{display the plot?}
}
\value{
A named list of the \code{ggplot} figures produced is invisbly returned.
}
\description{
Plot the Random Forest null distributions importance metrics, 
observed values, and p-values for
each predictor variable from the object produced by a 
call to \code{\link{rfPermute}}.
}
\details{
The function will generate an plot for each predictor, with facetted 
  importance metrics. The vertical red line shows the observed importance 
  score and the p-value is given in the facet label.
}
\examples{
# A regression model using the ozone example
data(airquality)
ozone.rfP <- rfPermute(
  Ozone ~ ., data = airquality, ntree = 100, 
  na.action = na.omit, nrep = 50, num.cores = 1
)
  
# Plot the null distributions and observed values.
plotNull(ozone.rfP) 

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
