% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{query_parser}
\alias{query_parser}
\title{Parse a query string}
\usage{
query_parser(query = NULL, delim = NULL)
}
\arguments{
\item{query}{The query as a single string}

\item{delim}{Optional delimiter of array values. If omitted it is expected
that arrays are provided in exploded form (e.g. \code{arg1=3&arg1=7})}
}
\value{
A named list giving the keys and values of the query. Values fron the
same key are combined if given multiple times
}
\description{
This function facilitates the parsing of querystrings, either from the URL or
a POST or PUT body with \code{Content-Type} set to
\code{application/x-www-form-urlencoded}.
}
\examples{
# Using delimiter to provide array
query_parser("?name=Thomas+Lin+Pedersen&numbers=1\%202\%203", delim = " ")

# No delimiter (exploded form)
query_parser("?name=Thomas\%20Lin\%20Pedersen&numbers=1&numbers=2&numbers=3")

}
