% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{dhis2_login}
\alias{dhis2_login}
\title{Establish connection to a DHIS2 instance}
\usage{
dhis2_login(base_url, user_name, password)
}
\arguments{
\item{base_url}{A character with the base URL of the target DHIS2 instance}

\item{user_name}{A character with the user name}

\item{password}{A character with the user's password}
}
\value{
An \code{httr2_response} object if the connection was successfully
established
}
\description{
Establish connection to a DHIS2 instance
}
\examples{
\dontrun{
  dhis2_log <- dhis2_login(
    base_url = "https://play.im.dhis2.org/stable-2-42-1",
    user_name = "admin",
    password = "district"
  )
}
}
