% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.meta}
\alias{readDWD.meta}
\title{read dwd metadata (Beschreibung*.txt files)}
\usage{
readDWD.meta(file, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
DWDdata/daily_kl_recent_KL_Tageswerte_Beschreibung_Stationen.txt}

\item{quiet}{Ignored.
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=read.fwf]{read.fwf()}}}
}
\value{
data.frame
}
\description{
read dwd metadata (Beschreibung*.txt files).
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
Column widths for \code{\link[=read.fwf]{read.fwf()}} are computed internally.\cr
if(any(meta)), \code{\link[=readDWD]{readDWD()}} tries to set the locale to German
(to handle Umlaute correctly). It is hence not recommended to call
\code{rdwd:::readDWD.meta} directly on a file!\cr
Names can later be changed to ascii with
\code{\link[berryFunctions:convertUmlaut]{berryFunctions::convertUmlaut()}}.
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests

link <- selectDWD(res="daily", var="kl", per="r", meta=TRUE)
link <- link[!grepl("mn4", link)] # for mn4 file May 2022
link <- grep(".txt$", link, value=TRUE)
if(length(link)!=1) stop("length of link should be 1, but is ", length(link),
                ":\n", berryFunctions::truncMessage(link,prefix="",sep="\n"))

file <- dataDWD(link, dir=locdir(), read=FALSE)
meta <- readDWD(file)
head(meta)

cnm <- colnames(meta)
if(length(cnm)!=8) stop("number of columns should be 8, but is ", length(cnm),
                        ":\n", toString(cnm))
}
}
\seealso{
\code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}
}
