% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD}
\alias{readDWD}
\title{Process data from the DWD CDC FTP Server}
\usage{
readDWD(
  file,
  type = fileType(file),
  varnames = FALSE,
  fread = NA,
  format = NA,
  tz = "GMT",
  dividebyten = TRUE,
  var = "",
  progbar = !quiet,
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{file}{Char (vector): name(s) of the file(s) downloaded with
\code{\link[=dataDWD]{dataDWD()}},
e.g. "~/DWDdata/tageswerte_KL_02575_akt.zip" or
"~/DWDdata/RR_Stundenwerte_Beschreibung_Stationen.txt"}

\item{type}{Character (vector) determining which subfunction to call.
DEFAULT:  \code{\link{fileType}}\code{(file)}.}

\item{varnames}{Logical (vector): Expand column names?
Only used in \code{\link[=readDWD.data]{readDWD.data()}}.
DEFAULT: FALSE (for backward compatibility)}

\item{fread}{Logical (vector): read fast? Used in \code{\link[=readDWD.data]{readDWD.data()}}.
DEFAULT: NA}

\item{format, tz}{Format and time zone of time stamps, see \code{\link[=readDWD.data]{readDWD.data()}}}

\item{dividebyten}{Logical (vector): Divide the values in raster files by ten?
That way, [1/10 mm] gets transformed to [mm] units.
Used in \code{\link[=readDWD.radar]{readDWD.radar()}}, \code{\link[=readDWD.raster]{readDWD.raster()}} and \code{\link[=readDWD.asc]{readDWD.asc()}}.
DEFAULT: TRUE}

\item{var}{var for \code{\link[=readDWD.nc]{readDWD.nc()}}. DEFAULT: ""}

\item{progbar}{Logical: present a progress bar with estimated remaining time?
If missing and length(file)==1, progbar is internally set to FALSE,
unless binary files are to be read.
DEFAULT: !quiet}

\item{quiet}{Logical: suppress messages? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to the internal \verb{readDWD.*}
subfunctions (see \code{\link{fileType}}) and from those to the
underlying actual reading functions}
}
\value{
For observational data, an invisible data.frame of the desired dataset,
or a named list of data.frames if length(file) > 1.\cr
For gridded data, raster objects.
}
\description{
Read climate data that was downloaded with \code{\link[=dataDWD]{dataDWD()}}.
The data is unzipped and subsequently, the file(s) are read, processed and
returned as a data.frame / raster object.\cr\cr
For observational data, new users are advised to set \code{varnames=TRUE}
to obtain more informative column names.\cr\cr
\code{readDWD} will call internal (but documented) subfunctions depending on the
argument \code{type}, see the overview in \code{\link[=fileType]{fileType()}}.\cr\cr
Not all arguments to \code{readDWD} are used for all subfunctions, e.g.
\code{fread} is used only by \code{\link{readDWD.data}}, while \code{dividebyten}
is used in \code{\link{readDWD.raster}} and \code{\link{readDWD.asc}}.\cr\cr
\code{file} can be a vector with several filenames. Most other arguments can
also be a vector and will be recycled to the length of \code{file}.
}
\examples{
# see dataDWD and readDWD.* subfunctions

}
\seealso{
\code{\link[=dataDWD]{dataDWD()}}, \code{\link[=readVars]{readVars()}}, \code{\link[=readMeta]{readMeta()}}, \code{\link[=selectDWD]{selectDWD()}}, \code{\link[=fileType]{fileType()}}\cr
\url{https://bookdown.org/brry/rdwd}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jul-Oct 2016, Winter 2018/19
}
\keyword{chron}
\keyword{file}
