% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setter_getter_for_default_folders.R
\name{setters_getters}
\alias{setters_getters}
\alias{get_default_rcreds_folder}
\alias{set_default_rcreds_folder}
\alias{clear_default_rcreds_folder}
\alias{get_default_rcreds_key_folder}
\alias{set_default_rcreds_key_folder}
\alias{clear_default_rcreds_key_folder}
\alias{set_default_rcreds_ALL}
\title{Setter Getter for Default rcreds Folders}
\usage{
get_default_rcreds_folder(DB = FALSE, check_if_exists = TRUE,
  fail_if_not_set = TRUE, showWarnings = TRUE)

set_default_rcreds_folder(folder, DB = FALSE, create_if_not_exist = FALSE,
  showWarnings = TRUE, verbose = TRUE)

clear_default_rcreds_folder(DB = FALSE, verbose = TRUE)

get_default_rcreds_key_folder(check_if_exists = TRUE,
  fail_if_not_set = TRUE, showWarnings = TRUE)

set_default_rcreds_key_folder(folder, create_if_not_exist = FALSE,
  showWarnings = TRUE, verbose = TRUE)

clear_default_rcreds_key_folder(verbose = TRUE)

set_default_rcreds_ALL(parent_folder, create_if_not_exist = FALSE,
  showWarnings = TRUE, verbose = TRUE)
}
\arguments{
\item{DB}{TRUE/FALSE flag. Is the folder for the db credentials functions?

          Defaults to: FALSE}

\item{check_if_exists}{TRUE/FALSE flag. Should we check if the folder exists

                       Defaults to: TRUE}

\item{fail_if_not_set}{TRUE/FALSE flag. Should an error be thrown if 
                        the option is not set?

                       Defaults to: TRUE}

\item{showWarnings}{When FALSE, warnings will be supressed.

                    Defaults to: TRUE}

\item{folder}{full path/to/folder where to store creds or key. A quoted string}

\item{create_if_not_exist}{If folder does not exist, should it be created.

                           Defaults to: FALSE}

\item{verbose}{When FALSE, output will be supressed.

               Defaults to: TRUE}

\item{parent_folder}{full path/to/parent_folder in which three subfolders will 
be (optionally) created to store credentials and keys}
}
\value{
The folder set in the options. 

    for the \code{set_default_..} functions, the folder is returned invisibly.

    for the \code{clear_default_..} functions, the previously set value, invisibly.
}
\description{
Where will your keys and credentials be saved to and read from
}
\details{
Ideally, rcreds will be written to \code{~/.rcreds/}, but 
  the package cannot set that as a default. The user must do so.
}
\examples{

 \dontrun{
   library(rcreds)

   set_default_rcreds_folder("~/.rcreds/credential_files")
   creds_folder <- get_default_rcreds_folder()
   creds_folder

   set_default_rcreds_folder("~/.rcreds/db_credential_files", DB=TRUE)
   db_creds_folder <- get_default_rcreds_folder(DB=TRUE)
   db_creds_folder

   set_default_rcreds_key_folder("~/.rcreds/key_files")
   rcreds_key_folder <- get_default_rcreds_key_folder()
   rcreds_key_folder
 
   ## ---------------------------------------------- ##

   ## Alternatively, set them all in one shot
   set_default_rcreds_ALL(parent_folder = "~/.rcreds")

   ## All three values will be set
   get_default_rcreds_folder()
   get_default_rcreds_folder(DB=TRUE)
   get_default_rcreds_key_folder()
 }

}
