% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{rubin_df}
\alias{rubin_df}
\title{Barnard and Rubin degrees of freedom adjustment}
\usage{
rubin_df(v_com, var_b, var_t, M)
}
\arguments{
\item{v_com}{Positive number representing the degrees of freedom in the complete-data analysis.}

\item{var_b}{Between-variance of point estimate across multiply imputed datasets.}

\item{var_t}{Total-variance of point estimate according to Rubin's rules.}

\item{M}{Number of imputations.}
}
\value{
Degrees of freedom according to Barnard-Rubin formula. See Barnard-Rubin (1999).
}
\description{
Compute degrees of freedom according to the Barnard-Rubin formula.
}
\details{
The computation takes into account limit cases where there is no missing data
(i.e. the between-variance \code{var_b} is zero) or where the complete-data degrees of freedom is
set to \code{Inf}. Moreover, if \code{v_com} is given as \code{NA}, the function returns \code{Inf}.
}
\references{
Barnard, J. and Rubin, D.B. (1999).
Small sample degrees of freedom with multiple imputation. Biometrika, 86, 948-955.
}
