% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showRatioOfQsprays}
\alias{showRatioOfQsprays}
\title{Print a 'ratioOfQsprays' object}
\usage{
showRatioOfQsprays(
  showQspray,
  quotientBar = "  \%//\%  ",
  lbracket = "[ ",
  rbracket = " ]"
)
}
\arguments{
\item{showQspray}{a function which prints a \code{qspray} object, which will
be applied to the numerator and the denominator}

\item{quotientBar}{a string representing the quotient bar between the
numerator and the denominator, including surrounding spaces,
e.g \code{" / "}}

\item{lbracket, rbracket}{used to enclose the numerator and the denominator}
}
\value{
A function which takes as argument a \code{ratioOfQsprays} object
  and which prints it.
}
\description{
Prints a \code{ratioOfQsprays} object given a function to print
  a \code{qspray} object
}
\note{
The function returned by this function can be used as the option
  \code{"showRatioOfQsprays"} of the setter function
  \code{\link{showRatioOfQspraysOption<-}}. That said, one would more often
  uses \code{\link{showRatioOfQspraysX1X2X3}} or
  \code{\link{showRatioOfQspraysXYZ}} for this option, which are both built
  with \code{showRatioOfQsprays}.
}
\examples{
set.seed(666)
( roq <- rRatioOfQsprays() )
f <- showRatioOfQsprays(showQsprayX1X2X3("a"), " / ", "[[ ", " ]]")
f(roq)
# this is equivalent to
f <- showRatioOfQspraysX1X2X3("a", " / ", lbracket = "[[ ", rbracket = " ]]")
f(roq)
}
\seealso{
\code{\link{showRatioOfQspraysX1X2X3}},
  \code{\link{showRatioOfQspraysXYZ}},
  \code{\link{showRatioOfQspraysOption<-}},
  \code{\link[qspray]{showQspray}}.
}
