% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{as.function.ratioOfQsprays}
\alias{as.function.ratioOfQsprays}
\title{Ratio of multivariate polynomials as function}
\usage{
\method{as.function}{ratioOfQsprays}(x, N = FALSE, ...)
}
\arguments{
\item{x}{object of class \code{ratioOfQsprays}}

\item{N}{Boolean, whether the function must numerically approximate
the result}

\item{...}{ignored}
}
\value{
A function having the same variables as the polynomial. If
  \code{N=FALSE}, it returns a string. If \code{N=TRUE}, it returns a number
  if the result does not contain any variable, otherwise it returns a
  R expression.
}
\description{
Coerces a \code{ratioOfQsprays} polynomial to a function.
}
\examples{
library(ratioOfQsprays)
x <- qlone(1); y <- qlone(2)
roq <- (x^2/2 + y^2 + x*y - 1) / (x + 1)
f <- as.function(roq)
g <- as.function(roq, N = TRUE)
f(2, "3/7")
g(2, "3/7")
f("x", "y")
g("x", "y")
# the evaluation is performed by (R)yacas and complex numbers are
# allowed; the imaginary unit is denoted by \code{I}:
f("2 + 2*I", "Sqrt(2)")
g("2 + 2*I", "Sqrt(2)")
}
