% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainette2.R
\name{rainette2}
\alias{rainette2}
\title{Corpus clustering based on the Reinert method - Double clustering}
\usage{
rainette2(
  x,
  y = NULL,
  max_k = 5,
  min_segment_size1 = 10,
  min_segment_size2 = 15,
  doc_id = NULL,
  min_members = 10,
  min_chi2 = 3.84,
  parallel = FALSE,
  full = TRUE,
  uc_size1,
  uc_size2,
  ...
)
}
\arguments{
\item{x}{either a quanteda dfm object or the result of \code{\link[=rainette]{rainette()}}}

\item{y}{if \code{x} is a \code{\link[=rainette]{rainette()}} result, this must be another \code{\link[=rainette]{rainette()}}
result from same dfm but with different uc size.}

\item{max_k}{maximum number of clusters to compute}

\item{min_segment_size1}{if \code{x} is a dfm, minimum uc size for first clustering}

\item{min_segment_size2}{if \code{x} is a dfm, minimum uc size for second clustering}

\item{doc_id}{character name of a dtm docvar which identifies source documents.}

\item{min_members}{minimum members of each cluster}

\item{min_chi2}{minimum chi2 for each cluster}

\item{parallel}{if TRUE, use \code{parallel::mclapply} to compute partitions
(won't work on Windows, uses more RAM)}

\item{full}{if TRUE, all crossed groups are kept to compute optimal partitions, otherwise
only the most mutually associated groups are kept.}

\item{uc_size1}{deprecated, use min_segment_size1 instead}

\item{uc_size2}{deprecated, use min_segment_size2 instead}

\item{...}{if \code{x} is a dfm object, parameters passed to \code{\link[=rainette]{rainette()}} for both
simple clusterings}
}
\value{
A tibble with optimal partitions found for each available value of \code{k} as rows, and the following
columns :
\itemize{
\item \code{clusters} list of the crossed original clusters used in the partition
\item \code{k} the number of clusters
\item \code{chi2} sum of the chi2 value of each cluster
\item \code{n} sum of the size of each cluster
\item \code{groups} group membership of each document for this partition (\code{NA} if not assigned)
}
}
\description{
Corpus clustering based on the Reinert method - Double clustering
}
\details{
You can pass a quanteda dfm as \code{x} object, the function then performs two simple
clustering with varying minimum uc size, and then proceed to find optimal partitions
based on the results of both clusterings.

If both clusterings have already been computed, you can pass them as \code{x} and \code{y} arguments
and the function will only look for optimal partitions.

\code{doc_id} must be provided unless the corpus comes from \code{split_segments},
in this case \code{segment_source} is used by default.

If \code{full = FALSE}, computation may be much faster, but the chi2 criterion will be the only
one available for best partition detection, and the result may not be optimal.

For more details on optimal partitions search algorithm, please see package vignettes.
}
\examples{
\donttest{
require(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
tok <- tokens(corpus, remove_punct = TRUE)
tok <- tokens_remove(tok, stopwords("en"))
dtm <- dfm(tok, tolower = TRUE)
dtm <- dfm_trim(dtm, min_docfreq = 3)

res1 <- rainette(dtm, k = 5, min_segment_size = 10)
res2 <- rainette(dtm, k = 5, min_segment_size = 15)

res <- rainette2(res1, res2, max_k = 4)
}

}
\references{
\itemize{
\item Reinert M, Une méthode de classification descendante hiérarchique : application à l'analyse lexicale par contexte, Cahiers de l'analyse des données, Volume 8, Numéro 2, 1983. \url{http://www.numdam.org/item/?id=CAD_1983__8_2_187_0}
\item Reinert M., Alceste une méthodologie d'analyse des données textuelles et une application: Aurelia De Gerard De Nerval, Bulletin de Méthodologie Sociologique, Volume 26, Numéro 1, 1990.  \doi{10.1177/075910639002600103}
}
}
\seealso{
\code{\link[=rainette]{rainette()}}, \code{\link[=cutree_rainette2]{cutree_rainette2()}}, \code{\link[=rainette2_plot]{rainette2_plot()}}, \code{\link[=rainette2_explor]{rainette2_explor()}}
}
