% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aided_chatgpt.R
\name{cols.rep}
\alias{cols.rep}
\title{Replicate Columns in a Data Frame}
\usage{
cols.rep(data, n)
}
\arguments{
\item{data}{A data frame whose columns are to be replicated.}

\item{n}{An integer specifying the number of times each column should be replicated.}
}
\value{
A data frame with each column replicated `n` times. If `n` is less than or equal to 0, an empty data frame is returned.
}
\description{
This function replicates each column in a data frame a specified number of times.
}
\examples{
# Example with a simple data frame
df <- data.frame(A = c(1, 2), B = c(3, 4))
cols.rep(df, 3)

# Example with no replication (n = 0)
cols.rep(df, 0)

}
