% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomImage.R
\name{genRandImg}
\alias{genRandImg}
\title{Download random images from the web}
\usage{
genRandImg(
  fp,
  cat = imageCategories,
  n = 1,
  w.px = 500,
  h.px = 500,
  ext = "jpg"
)
}
\arguments{
\item{fp}{storage directory}

\item{cat}{category of image to download}

\item{n}{number of images to download, maximum n is 99}

\item{w.px}{width in pixels}

\item{h.px}{height in pixels}

\item{ext}{file extension eg jpg, png}
}
\value{
downloaded image from a select image category
}
\description{
Generate n number of high-definition images by category from the web
}
\section{Sources & References}{

The random images are downloaded from www.unsplash.com
}

\section{Category Choices}{

Categories for 'cat' argument include
"3D", "animals", "architecture", "backgrounds", "beauty", "experimental",
"fashion", "film", "food", "interior", "nature", "people", "renders",
"school", "sports", "travel", "unsplash", "wallpapers"
}

\section{Use case}{

This functionality is great for developers trying to obtain one or more images for use in displays/analysis
or simply to build robust web applications.
}

\examples{
\donttest{
# download 2 image from the nature category
genRandImg(fp = tempdir(),cat = "nature", n = 2)

# download 4 random images with width = 600px and hight 100px
genRandImg(
  fp = tempdir(),
  cat = "fashion",
  w.px = 600,
  h.px = 100)

# download 10 random images with extension png
genRandImg(fp = tempdir(),cat = "food", n = 10, ext = "png")


# download 200 random images from category of school
# Note that maximum download is 99, so the function will only download 99
genRandImg(fp = tempdir(),cat = "school", n = 200)
}
}
