% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{set}
\alias{set}
\title{Stack Multiple Data Frames}
\usage{
set(..., id = FALSE, compress = NULL, guessing_rows = 100)
}
\arguments{
\item{...}{Put in multiple data frames to stack them in the provided order.}

\item{id}{Adds an ID column to indicate the different data frames.}

\item{compress}{No compression by default. If compression receives any value, \code{\link[=set]{set()}}
will convert character variables to numeric or integer where possible. If set to "factor"
all non numeric character variables will be converted to factors.}

\item{guessing_rows}{100 by default. \code{\link[=set]{set()}} takes a sample of rows to determine of
which type variables are.}
}
\value{
Returns a stacked data frame.
}
\description{
Stacks multiple data frames and matches column names.
}
\examples{
# Example data frames
my_data1 <- dummy_data(100)
my_data2 <- dummy_data(100)
my_data3 <- dummy_data(100)
my_data4 <- dummy_data(100)
my_data5 <- dummy_data(100)

# Stack data frames
stacked_df <- set(my_data1,
                  my_data2,
                  my_data3,
                  my_data4,
                  my_data5)

}
