% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_get_pxweb_data.R
\name{get_pxweb_data}
\alias{get_pxweb_data}
\title{Get data from a bottom node in PX-WEB API}
\usage{
get_pxweb_data(url, dims, clean = FALSE, encoding = NULL)
}
\arguments{
\item{url}{URL to get data from (usually sufficient to submit the base URL, supplied via the base_url() function, and the name of the variable).}

\item{dims}{A list of dimensional parameters to filter data by. Note that values \emph{must} be submitted for all dimensions of the data. If you don't want to filter data, submit an asterisk in quotation marks ("*") instead of values for that dimension.}

\item{clean}{Clean and melt the data to R format.}

\item{encoding}{An encoding for data to get. Normally not requred. Will be supplied to \code{\link[httr]{content}}.}
}
\description{
This function fetches actual data (i.e. values)
}
\details{
There are five documented filter types in the PX-WEB API documentation; "Item", "All", "Top", "Agg" and "Vs". This function currently only supports the "Item" and "All" modes. 
To use "Item" selection, simply submit a value or vector of values with each dimensional parameter. To use "All" selection, submit a wildcard asterisk ("*") instead of a value.
For detailed examples see the installed example files in the \code{examples} folder of \code{path.package("pxweb")} (these are also viewable on the project's GitHub page).
}
\examples{
\dontrun{
test_data <- 
  get_pxweb_data(url = "http://api.scb.se/OV0104/v1/doris/sv/ssd/PR/PR0101/PR0101E/Basbeloppet", 
                 dims = list(ContentsCode = c('PR0101A1'), Tid = c('*')),
                 clean = FALSE)
}
}
\seealso{
\code{\link{get_pxweb_metadata}}, \code{\link{get_pxweb_dims}}, \code{\link{get_pxweb_levels}}
}
\keyword{internal}
