% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{pxweb_api-class}
\alias{pxweb_api}
\alias{pxweb_api-class}
\title{A Reference Class to represent an pxweb_api}
\description{
A Reference Class to represent an pxweb_api
}
\section{Fields}{

\describe{
\item{\code{api}}{The name of the api (api domain)}

\item{\code{description}}{Short description of the pxweb api.}

\item{\code{url}}{An url template for the pxweb api.}

\item{\code{versions}}{A character vector with versions of the api.}

\item{\code{languages}}{A character vector with languages of the api.}

\item{\code{calls_per_period}}{The number of allowed calls per period.}

\item{\code{period_in_seconds}}{The length of the period with allowed calls.}

\item{\code{max_values_to_download}}{Maximum number of values to download with each call.}
}}
\section{Methods}{

\describe{
\item{\code{base_url(version = NULL, language = NULL)}}{Create a base url from the api for version and language.
The first element of versions and languages is used as standard.}

\item{\code{check_alt(version = NULL, language = NULL)}}{Check if the version/language alternative exist in the object.}

\item{\code{check_input()}}{Check the consistency of the fields.}

\item{\code{get_api(api_name)}}{Get the api configuration from inst/extdata/api.json for the 
api_name.}

\item{\code{initialize(get_api = NULL, ...)}}{Create a new pxweb_api object.}

\item{\code{pxweb_api_to_list()}}{Create a list of the current pxweb_api object}

\item{\code{test_api(test_type = "fast", seed = as.integer(Sys.time()))}}{Test to connect to the api and download for each api version/language.

         :param test_type: c("fast", "sample", "full"). 

                        "fast" check that one random datapoint can be downloaded from each api

                        "sample" check that one random datapoint can be downloaded from each node

                        "full" check that all datapoints can be downloaded

         :param seed: seed to use for random choice of data points.
         }

\item{\code{write_to_catalogue()}}{Save/overwrite the current api as a locally stored api.}
}}
\examples{
scb_pxweb_api <- pxweb_api$new(get_api = "api.scb.se")
 scb_pxweb_api
 \donttest{
 scb_pxweb_api$test_api()
 }
}

