% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_dim_size}
\alias{get_dim_size}
\title{The function calculates the dimension of a query. That means the numberof
categories for each variable downloaded}
\usage{
get_dim_size(url, dims, content_node = NULL)
}
\arguments{
\item{url}{The url the query uses}

\item{dims}{The dimension object to use for downloading}

\item{content_node}{Used if already a content node has been downloaded}
}
\value{
list with two slots
[[1]] containes named vector with number of slots
[[2]] containes content_node got with \link{get_pxweb_metadata}
}
\description{
The function calculates the dimension of a query. That means the numberof
categories for each variable downloaded
}
\examples{
url <- "http://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101/BE0101A/BefolkningNy"
dims <- list(Region = c('*'), Civilstand = c('*'), Alder = '1', Kon = c('*'),
            ContentsCode = c('*'), Tid = c('*'))
\donttest{
get_dim_size(url, dims)
}

url <- "http://api.scb.se/OV0104/v1/doris/en/ssd/BE/BE0401/BE0401A/BefolkprognRev2014"
dims <- list(Alder = c('0', '1', '2', '3', '4'),
             Kon = c('1', '2'),ContentsCode = c('BE0401AW'),
             Tid = c('2014', '2015', '2016', '2017', '2018'))
\donttest{
get_dim_size(url, dims)
}
}

