% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gbca2025}
\alias{gbca2025}
\title{FDA GBCA dataset with 1328 adverse events}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 1328 rows and 8 columns.
}
\source{
\url{https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html}
}
\usage{
gbca2025
}
\description{
An adverse event-drug count dataset (contingency table)
obtained from the FDA FAERS database for the
quarters 2021Q1 - 2024Q4.
}
\details{
Data are stored in the form of a contingency table, with
drugs listed across the columns and the 1328 AEs presented across
the rows. Each cell in the contingency table represents the total
report counts associated with that (AE, drug) pair and detected
in the FDA FAERS database during 2021Q1 - 2024Q4.

The dataset catalogs 7 Gadolinium-Based Contrast Agents (GBCAs) (across columns):

Gadobenate, Gadobutrol, Gadodiamide, Gadopentetate, Gadoterate, Gadoteridol,
Gadoxetate

The 1328 adverse events presented across the rows are AEs that contain at
least one report for the 7 GBCA drugs during 2021Q1 - 2024Q4.

This dataset is an updated version of gbca from the pvLRT package which collects
the same scope of AEs for 7 gbca drugs for quarters 2014Q3 - 2020Q4.
}
\keyword{datasets}
