% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_mesh_thesaurus.R
\name{data_mesh_thesaurus}
\alias{data_mesh_thesaurus}
\title{Download and Combine 'MeSH' and Supplemental Thesauruses}
\usage{
data_mesh_thesaurus(
  path = NULL,
  use_persistent_storage = FALSE,
  force_install = FALSE
)
}
\arguments{
\item{path}{A character string specifying the directory path where data should 
be stored. If not provided and persistent storage is requested, it defaults to 
a system-appropriate persistent location managed by `rappdirs`.}

\item{use_persistent_storage}{A logical value indicating whether to use persistent
storage. If TRUE and no path is provided, data will be stored in a system-appropriate 
location. Defaults to FALSE, using a temporary directory.}

\item{force_install}{A logical value indicating whether to force re-downloading 
of the data even if it already exists locally.}
}
\value{
A data.table containing the combined MeSH and supplemental thesaurus data.
}
\description{
This function downloads and combines the 'MeSH' (Medical Subject Headings) Thesaurus 
and a supplemental concept thesaurus.
The data is sourced from specified URLs and stored locally for subsequent use.
By default, the data is stored in a temporary directory. Users can opt into 
persistent storage by setting `use_persistent_storage` to TRUE and optionally 
specifying a path.
}
\examples{
\donttest{
if (interactive()) {
  data <- data_mesh_thesaurus()
}
}

}
