% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_study_length.R
\docType{data}
\name{meta_study_length}
\alias{meta_study_length}
\title{Metadata About Study Length}
\format{
A tibble with 16 rows and
6 variables:

\describe{
\item{\strong{project}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = 27) \cr
    \tab  \cr
   \emph{Description:} \tab CTN project number \cr
    \tab  \cr
   \emph{Levels:} \tab 27, 30, 51 \cr
}


}
\item{\strong{treatment}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Inpatient BUP) \cr
    \tab  \cr
   \emph{Description:} \tab \if{html}{\out{<ul>}}\if{html}{\out{<li>}}ctn_0027:\if{html}{\out{<ul>}}\if{html}{\out{<li>}}Methadone\if{html}{\out{</li>}}\if{html}{\out{<li>}}Outpatient BUP\if{html}{\out{</li>}}\if{html}{\out{</ul>}}\if{html}{\out{</li>}}\if{html}{\out{<li>}}ctn_0030: \if{html}{\out{<ul>}}\if{html}{\out{<li>}}Outpatient BUP + EMM\if{html}{\out{</li>}}\if{html}{\out{<li>}}Outpatient BUP + SMM\if{html}{\out{</li>}}\if{html}{\out{</ul>}}\if{html}{\out{</li>}}\if{html}{\out{<li>}}ctn_0051: \if{html}{\out{<ul>}}\if{html}{\out{<li>}}Outpatient BUP + EMM\if{html}{\out{</li>}}\if{html}{\out{<li>}}Outpatient BUP + SMM\if{html}{\out{</li>}}\if{html}{\out{</ul>}}\if{html}{\out{</li>}}\if{html}{\out{</ul>}} \cr
    \tab  \cr
   \emph{Levels:} \tab Inpatient BUP, Inpatient NR-NTX, Methadone, Outpatient BUP, Outpatient BUP + EMM, Outpatient BUP + SMM \cr
}


}
\item{\strong{phase}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = 1) \cr
    \tab  \cr
   \emph{Description:} \tab Study phase (needed because of CTN 30) \cr
    \tab  \cr
   \emph{Levels:} \tab 1, 2 \cr
}


}
\item{\strong{stage}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = 1) \cr
    \tab  \cr
   \emph{Description:} \tab Treatment stage used with \code{description} to capture different treatment phase/stage/period \cr
    \tab  \cr
   \emph{Levels:} \tab 1, 2, 3 \cr
}


}
\item{\strong{weeks}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Treatment duration in weeks \cr
}


}
\item{\strong{description}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Buprenorphine-naloxone stabilization) \cr
    \tab  \cr
   \emph{Description:} \tab Description of the treatment duration \cr
    \tab  \cr
   \emph{Levels:} \tab Buprenorphine-naloxone stabilization, Buprenorphine-naloxone treatment, Post-medication follow-up, Taper, Treatment \cr
}


}
}
}
\usage{
data(meta_study_length)
}
\description{
This is information on the duration of CTN-0094 trial periods.
}
\keyword{datasets}
