% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_model.R
\name{glm_model}
\alias{glm_model}
\title{Generalized Linear Regression}
\usage{
glm_model(
  data,
  response_variable,
  predictor_variable,
  two_way_interaction_factor = NULL,
  three_way_interaction_factor = NULL,
  family,
  quite = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{response_variable}{response variable. Support \code{dplyr::select()} syntax.}

\item{predictor_variable}{predictor variable. Support \code{dplyr::select()} syntax.}

\item{two_way_interaction_factor}{two-way interaction factors. You need to pass 2+ factor. Support \code{dplyr::select()} syntax.}

\item{three_way_interaction_factor}{three-way interaction factor. You need to pass exactly 3 factors. Specifying three-way interaction factors automatically included all two-way interactions, so please do not specify the two_way_interaction_factor argument. Support \code{dplyr::select()} syntax.}

\item{family}{a GLM family. It will passed to the family argument in glmer. See \code{?glmer} for possible options.}

\item{quite}{suppress printing output}
}
\value{
an object class of \code{glm} representing the linear regression fit
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \cr
Fit a generalized linear regression using \code{glm()}. This function is still in early development stage.
}
\examples{
fit <- glm_model(
  response_variable = incidence,
  predictor_variable = period,
  family = "poisson", # or you can enter as poisson(link = 'log'),
  data = lme4::cbpp
)
}
