% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalar.R
\name{pspline.sample.scalars}
\alias{pspline.sample.scalars}
\title{Runs simulations on an outbreak GAM/GAMM for the purpose of estimating
scalar outbreak outcomes, and returns estimated scalar outcome values for each simulation.}
\usage{
pspline.sample.scalars(model, predictors, calc.outcomes, samples = 100)
}
\arguments{
\item{model}{model returned by \code{\link[mgcv]{gam}} or \code{\link[mgcv]{gamm}}}

\item{samples}{number of simulations to run}

\item{time}{time values at which the model will be evaluated during simulation}

\item{outcomes}{scalar outcome generator function; see \code{\link{pspline.estimate.scalars}} for more info}
}
\value{
data frame with one row for each simulation; each row has \code{pspline.sample} column giving
a unique ID for the simulation, and one column for each scalar outcome returned by \code{outcomes}
}
\description{
This is mainly used internally by \code{pspline.estimate.scalars}, but it's
useful if you want to calculate summary statistics of simulation results other than
the ones returned by \code{pspline.estimate.scalars}.
}
\keyword{internal}
