% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bboxtools.R
\name{searchbbox}
\alias{searchbbox}
\title{Query The Interwebs For A Bounding Box}
\usage{
searchbbox(querystring, ...)
}
\arguments{
\item{querystring}{The search query. Passing a vector in will find the bounding box that contains
all bounding boxes returned.}

\item{...}{Additional paramters to be passed on to \link{geocode}. Passing \code{source="google"}
may be useful if google is desired as a source. Use \code{options(prettymapr.geosource="google")}
to permanently use \code{google} as a source.}
}
\value{
A 2x2 matrix describing a bounding box like that returned by \code{sp::bbox()}
}
\description{
Use the \href{https://pickpoint.io/}{PickPoint.io API} or Google API to
retreive a bounding box for the given query. Note that if
you would like to use \code{google} as a source, you must agree to the Google
API \href{https://developers.google.com/terms/}{terms and conditions}.
}
\examples{
#don't test to speed up checking time
\donttest{
searchbbox("kings county, NS")
searchbbox("University Ave. Wolfville NS", source="google")
searchbbox("Wolfville ns", source="google")
searchbbox(c("Vermont", "Nova Scotia"))
}

}

