% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hstore.R
\name{new_hstore}
\alias{new_hstore}
\title{Create a empty hstore}
\usage{
new_hstore(nr)
}
\arguments{
\item{nr}{Number of records.}
}
\value{
A empty hstore (list of lists) of length \code{nr}.
}
\description{
This function creates an empty list of lists, which can be appended to a
data frame as a hstore column.
}
\examples{
contacts <- data.frame(name = c("Anne", "Bert", "Chris"))
contacts$phone <- new_hstore(3)
contacts$phone \%->\% "home" <- c("555-123-4567", "555-923-9134", "555-276-1123")
contacts$phone[2] \%->\% "cell" <- "555-889-9134"
str(contacts)

}
\seealso{
\code{\link{\%->\%}} to read or edit the resulting data structure.
}
