% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{scaled.migration}
\alias{scaled.migration}
\title{Compute scaled migration rates}
\usage{
scaled.migration(parameters, model, Nref = NA)
}
\arguments{
\item{parameters}{is a matrix of simulated parameter values i.e. numbers from
the simulations. Each row or vector entry should be a different simulation
and each column of a matrix should be a different parameter.}

\item{model}{a character, either 2pops", "Single" or "Parallel" indicating
which model was simulated.}

\item{Nref}{a numeric value indicating the effective population size of the
reference population.}
}
\value{
a matrix of simulated parameter values with added columns containing
the scaled migration rates.
}
\description{
Computes and adds scaled migration rates to a matrix of simulated parameter
values.
}
\details{
Migration rates are scaled according to the size of the population receiving
the migrants and added to a matrix with the simulated parameter values. This
is performed for the three available models and according to the specific
model conformation.
}
\examples{
# compute scaled migration for a two-population model
scaled.migration(parameters = myparams, model = "2pops", Nref = 10000)

}
