% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{rejABC}
\alias{rejABC}
\title{Parameter estimation with Approximate Bayesian Computation using rejection
sampling}
\usage{
rejABC(target, params, sumstats, tol, regression = FALSE)
}
\arguments{
\item{target}{a vector with the target summary statistics. These are usually
the set of observed summary statistics.}

\item{params}{is a vector or matrix of simulated parameter values i.e.
numbers from the simulations. Each row or vector entry should be a
different simulation and each column of a matrix should be a different
parameter.}

\item{sumstats}{is a vector or matrix of simulated summary statistics. Each
row or vector entry should be a different simulation and each column of a
matrix should be a different statistic.}

\item{tol}{is the tolerance rate, indicating the required proportion of
points accepted nearest the target values.}

\item{regression}{logical, indicating whether the user intends to perform a
local linear regression correction after the rejection step. If set to
FALSE (default) the output of this function will contain just the results
of the rejection step. If set to TRUE, the output will contain more details
required for the regression step.}
}
\value{
a list with the results of the rejection sampling algorithm. The
elements of the list depend of the logical value of \code{regression}.

\item{s.target}{a scaled vector of the observed summary statistics. This
element only exists if regression is TRUE.}

\item{unadjusted}{parameter estimates obtained with the rejection
sampling.}

\item{ss}{set of accepted summary statistics from the simulations.}

\item{s.sumstat}{set of scaled accepted summary statistics from the
simulations. This element only exists if regression is TRUE.}

\item{dst}{euclidean distances in the region of interest.}
}
\description{
This function performs multivariate parameter estimation based on summary
statistics using an Approximate Bayesian Computation (ABC) algorithm. The
algorithm used here is the rejection sampling algorithm. The output of this
function can be tailored towards a posterior local linear regression method
correction.
}
\details{
The rejection sampling algorithm generates random samples from the posterior
distributions of the parameters of interest. Note that to use this function,
the usual steps of ABC parameter estimation have to be performed. Briefly,
data should have been simulated based on random draws from the prior
distributions of the parameters of interest and a set of summary statistics
should have been calculated from that data. The same set of summary
statistics should have been calculated from the observed data to be used as
the \code{target} input in this function. Parameter values are accepted if the
Euclidean distance between the set of summary statistics computed from the
simulated data and the set of summary statistics computed from the observed
data is sufficiently small. The percentage of accepted simulations is
determined by \code{tol}.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)

# select a random simulation to act as target just to test the function
target <- sumstats[10 ,]

# Parameter estimation using rejection sampling
rejABC(target = target, params = params, sumstats = sumstats[-10, ], tol = 0.01)

}
