% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{plot_errorABC}
\alias{plot_errorABC}
\title{Prediction error plots for ABC using a list}
\usage{
plot_errorABC(
  x,
  method,
  statistic,
  index,
  transformation = "none",
  main = NULL
)
}
\arguments{
\item{x}{is a list produced by a leave-one-out cross validation of ABC. This
list should contain the prediction errors computed using the rejection
and/or regression algorithm. For each of those methods, the prediction
error obtained using three different point estimates of the posterior
should be included in this list.}

\item{method}{a character that can be either 'rej' or 'reg' indicating
whether you wish to plot the prediction error computed with a rejection or
regression based ABC algorithm.}

\item{statistic}{a character that can be 'mode', 'median' or 'mean'
indicating if you wish to plot the prediction error obtained using the
mode, median or mean as the point estimate of the posterior.}

\item{index}{an integer indicating which parameter to look at. It corresponds
to a column on a matrix. So, to plot the first parameter, corresponding to
the first column, select 1. To plot the second parameter, select 2 and so
on.}

\item{transformation}{default is none. It can also be 'log' if you wish to
transform both the true and estimated values using a log10 scale.}

\item{main}{is an optional character input. It will be used as the title of
the plot. If NULL (default), then a generic title will be used instead.}
}
\value{
a plot of the estimated value of the parameter (in the y-axis) versus
the true parameter value (in the x-axis). A line marking the perfect
correspondence between the true and estimated values is also plotted. Thus,
the closer the points are to that line, the lower the prediction error is.
}
\description{
Plots the prediction error computed from a leave-one-out cross validation for
ABC parameter inference. This function takes as input a list created when
performing cross validation and allows the user to select which ABC algorithm
and point estimate statistic to plot.
}
\details{
These plots help in visualizing the quality of the estimation and the effect
of the chosen tolerance level or point estimate statistic.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# perform a leave-one-out cross validation for ABC
mysim <- simulationABC(params = params, sumstats = sumstats, limits, nval = 10,
tol = 0.1, method = "regression")

# plot the prediction error for a given parameter
plot_errorABC(x = mysim, method = "reg", statistic = "median", index = 1)

}
