% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_stochchastic.R
\name{round_stochastic}
\alias{round_stochastic}
\title{Round a stochastic vector or a row-stochastic matrix}
\usage{
round_stochastic(x, digits = 7)
}
\arguments{
\item{x}{a stochastic vector or a row-stochastic matrix.}

\item{digits}{number of digits for rounding.}
}
\value{
The rounded vector or matrix.
}
\description{
Rounds a vector such that the sum of 1 is preserved. Rounds a matrix such
that the rows still sum up to 1.
}
\details{
Rounds and adjusts one entry such that the rounding error is the smallest.
}
\examples{
# regular rounding would not sum up to 1 
x <- c(0.333, 0.334, 0.333)

round_stochastic(x)
round_stochastic(x, digits = 2)
round_stochastic(x, digits = 1)
round_stochastic(x, digits = 0)


# round a stochastic matrix
m <- matrix(runif(15), ncol = 3)
m <- sweep(m, 1, rowSums(m), "/")

m
round_stochastic(m, digits = 2)
round_stochastic(m, digits = 1)
round_stochastic(m, digits = 0)
}
\seealso{
\link{round}
}
