% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_belief_space.R
\name{sample_belief_space}
\alias{sample_belief_space}
\title{Sample from the Belief Space}
\usage{
sample_belief_space(model, projection = NULL, n = 1000, method = "random", ...)
}
\arguments{
\item{model}{a unsolved or solved \link{POMDP}.}

\item{projection}{Sample in a projected belief space. All states not
included in the projection are held at a belief of 0. \code{NULL} means no
projection.}

\item{n}{size of the sample.}

\item{method}{character string specifying the sampling strategy. Available
are \code{"random"}, \code{"regular"}, and \code{"vertices"}.}

\item{...}{further arguments are ignored.}
}
\value{
Returns a matrix. Each row is a sample from the belief space.
}
\description{
Sample randomly (uniform) or regularly spaced points from the projected
belief space.
}
\details{
Several sampling methods are implemented:
\itemize{
\item \code{'random'} samples uniformly sample from the projected belief space using
the method described by Luc Devroye (1986).
\item \code{'regular'} samples points using a
regularly spaced grid. This method is only available for projections on 2 or
3 states.
\item \code{'vertices'} only samples from the vertices of the belief space.
}
}
\examples{
data("Tiger")

sample_belief_space(Tiger, n = 5)
sample_belief_space(Tiger, n = 5, method = "regular")

# sample and calculate the reward for a solve POMDP
sol <- solve_POMDP(Tiger)
reward(sol, belief = sample_belief_space(sol, n = 5, method = "regular"))
}
\references{
Luc Devroye, Non-Uniform Random Variate Generation, Springer
Verlag, 1986.
}
\seealso{
Other POMDP: 
\code{\link{POMDP}()},
\code{\link{plot_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_matrix}()},
\code{\link{update_belief}()},
\code{\link{write_POMDP}()}
}
\author{
Michael Hahsler
}
\concept{POMDP}
