% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.isobaricnormRes}
\alias{plot.isobaricnormRes}
\title{Plot isobaricnormRes object}
\usage{
\method{plot}{isobaricnormRes}(
  x,
  order = FALSE,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = NULL,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "none",
  bw_theme = TRUE,
  palette = NULL,
  ...
)
}
\arguments{
\item{x}{an object of type isobaricnormRes, created by
\code{\link{normalize_isobaric}} with apply_norm = FALSE}

\item{order}{logical value. If TRUE the samples will be ordered by the column
of f_data containing the experiment/plate information.}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label}

\item{y_lab}{character string specifying the y-axis label}

\item{x_lab_size}{integer value indicating the font size for the x-axis. The
default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis. The
default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.}

\item{title_lab}{character string specifying the plot title.}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title.}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white
theme.}

\item{palette}{character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
Creates box plots for an S3 object of type 'isobaricnormRes'
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true") & requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
myiso <- edata_transform(omicsData = isobaric_object, data_scale = "log2")
result <- normalize_isobaric(myiso,
  exp_cname = "Plex",
  apply_norm = FALSE,
  refpool_cname = "Virus",
  refpool_notation = "Pool"
)
plot(result)
\dontshow{\}) # examplesIf}
}
