\name{kfolds2CVinfos_v2}
\alias{kfolds2CVinfos_v2}
\title{Extracts and computes information criteria and fits statistics for kfold cross validated partial least squares glm models}
\description{
This function extracts and computes information criteria and fits statistics for kfold cross validated partial least squares glm models.
}
\usage{
kfolds2CVinfos_v2(pls_kfolds, MClassed = FALSE)
}
\arguments{
  \item{pls_kfolds}{an object computed using \code{\link{PLS_v2_kfoldcv}}}
  \item{MClassed}{should number of miss classed be computed}
}
\details{
The Mclassed option should only set to \code{TRUE} if the response is binary. 
}
\value{
  \item{list}{table of fit statistics for first group partition}
  \item{\dots}{\dots}
  \item{list}{table of fit statistics for last group partition}
}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et \enc{Frdric}{Fr\'ed\'eric} Bertrand (2010). Comparaison de la \enc{rgression}{r\'egression} PLS et de la \enc{rgression}{r\'egression} logistique PLS : application aux \enc{donnes}{donn\'ees} \enc{d'alllotypage}{d'all\'elotypage}. \emph{Journal de la Socit Franaise de Statistique}, 151(2), pages 1-18.
\url{http://smf4.emath.fr/Publications/JSFdS/151_2/pdf/sfds_jsfds_151_2_1-18.pdf}
}
\author{\enc{Frdric}{Fr\'ed\'eric} Bertrand\cr
\email{frederic.bertrand@math.unistra.fr}\cr
\url{http://www-irma.u-strasbg.fr/~fbertran/}
}
\note{Use \code{\link{kfolds2CVinfos_glm}} and \code{\link{PLS_glm_kfoldcv}} instead.}
\seealso{\code{\link{kfolds2coeff}}, \code{\link{kfolds2Pressind}}, \code{\link{kfolds2Press}}, \code{\link{kfolds2Mclassedind}} and \code{\link{kfolds2Mclassed}} to extract and transforms results from kfold cross validation.}
\examples{\donttest{
data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
bbb <- PLS_v2_kfoldcv(dataY=yCornell,dataX=data.frame(scale(as.matrix(XCornell))[,]),nt=6,K=12,NK=1,keepfolds=FALSE,keepdataY=TRUE,modele="pls")
kfolds2CVinfos_v2(bbb)
rm(list=c("XCornell","yCornell","bbb"))


data(aze_compl)
Xaze_compl<-aze_compl[,2:34]
yaze_compl<-aze_compl$y
bbb <- PLS_v2_kfoldcv(yaze_compl,Xaze_compl,nt=10,K=12,NK=1,keepfolds=FALSE,keepdataY=TRUE,modele="pls")
kfolds2CVinfos_v2(bbb,MClassed=TRUE)
bbb2 <- PLS_v2_kfoldcv(yaze_compl,Xaze_compl,nt=10,K=12,NK=1,keepfolds=FALSE,keepdataY=TRUE,modele="pls-glm-logistic")
kfolds2CVinfos_v2(bbb2,MClassed=TRUE)
rm(list=c("Xaze_compl","yaze_compl","bbb","bbb2"))
}
}\keyword{models}
\keyword{regression}
