% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{legend_margin}
\alias{legend_margin}
\title{Add legend with respect to figure instead of plot region. 
Allows to move legend to margin of plot.}
\usage{
legend_margin(x, legend, adj = NULL, ...)
}
\arguments{
\item{x}{Text string, the location of the legend relative to the figure 
region. Single keyword from the list "bottomright", "bottom", "bottomleft", 
"left", "topleft", "top", "topright", "right" and "center".}

\item{legend}{Vector with text strings to appear in the legend.}

\item{adj}{Numeric vector of length 1 or 2; the string adjustment for 
legend text.}

\item{...}{Other parameters for specifying the legend 
(see \code{\link[graphics]{legend}}).}
}
\description{
Add legend with respect to figure instead of plot region. 
Wrapper around the function \code{\link[graphics]{legend}}.
}
\examples{
plot(cars$speed, cars$dist, pch=16)
legend_margin("topleft", legend=c("points"), pch=16)
# compare with default legend:
legend("topleft", legend=c("points"), pch=16)
}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fill_area}},
  \code{\link{getCoords}}, \code{\link{getFigCoords}},
  \code{\link{getProps}}, \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}
}

