% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractPackageReporter.R
\name{AbstractPackageReporter}
\alias{AbstractPackageReporter}
\title{Abstract Package Reporter}
\description{
pkgnet defines several package reporter R6 classes that analyze 
some particular aspect of a package. These reporters share common
functionality and interfaces defined by a base reporter class
\code{AbstractPackageReporter}.
}
\concept{Reporters}
\keyword{internal}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{pkg_name}}{(character string) name of set package. Read-only.}

\item{\code{report_markdown_path}}{(character string) path to R Markdown template for this reporter. Read-only.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AbstractPackageReporter-set_package}{\code{AbstractPackageReporter$set_package()}}
\item \href{#method-AbstractPackageReporter-get_summary_view}{\code{AbstractPackageReporter$get_summary_view()}}
\item \href{#method-AbstractPackageReporter-clone}{\code{AbstractPackageReporter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractPackageReporter-set_package"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractPackageReporter-set_package}{}}}
\subsection{Method \code{set_package()}}{
Set the package that the reporter will analyze. This can 
only be done once for a given instance of a reporter. 
Instantiate a new copy of the reporter if you need to analyze a different package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractPackageReporter$set_package(pkg_name, pkg_path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pkg_name}}{(character string) name of package}

\item{\code{pkg_path}}{(character string) optional directory path to source code of the package. 
It is used for calculating test coverage. It can be an absolute or relative path.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractPackageReporter-get_summary_view"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractPackageReporter-get_summary_view}{}}}
\subsection{Method \code{get_summary_view()}}{
Returns an htmlwidget object that summarizes the analysis of the reporter. 
Used when creating a \link[=CreatePackageReport]{package report}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractPackageReporter$get_summary_view()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractPackageReporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractPackageReporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractPackageReporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
