% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dist_pbox.R
\name{fit_dist_pbox}
\alias{fit_dist_pbox}
\alias{fit_dist_pbox,ANY-method}
\title{Fit Marginal Distributions}
\usage{
fit_dist_pbox(data, ...)

\S4method{fit_dist_pbox}{ANY}(data, ...)
}
\arguments{
\item{data}{A data frame or data table.}

\item{...}{Additional parameters to pass to the fitting function.}
}
\value{
A list containing two elements:
        \item{allDitrs}{List of the fitted distributions for each variable.}
        \item{distTable}{A data table displaying the AIC for each tested distribution.}
}
\description{
Fits the best marginal distribution for each variable in a data frame using the `gamlss::fitDist`
function from the GAMLSS package. This function is designed to evaluate multiple distributions,
returning a summary of fit for each, along with the Akaike Information Criterion (AIC) for comparison.

Implements the generic function `fit_dist_pbox` for data frames and data tables.
This method utilizes statistical techniques to fit distributions to each column in the `data`
argument, evaluating fit using criteria like AIC to determine the best fitting model.
}
\examples{
  data(SEAex)
  distFits <- fit_dist_pbox(data=SEAex)
  print(distFits$allDitrs)
  print(distFits$distTable)
}
