% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg_glm.R
\name{details_poisson_reg_glm}
\alias{details_poisson_reg_glm}
\title{Poisson regression via glm}
\description{
\code{\link[stats:glm]{stats::glm()}} uses maximum likelihood to fit a model for count data.
}
\details{
For this engine, there is a single mode: regression
\subsection{Tuning Parameters}{

This engine has no tuning parameters.
}

\subsection{Translation from parsnip to the underlying model call (regression)}{

The \strong{poissonreg} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(poissonreg)

poisson_reg() |>
  set_engine("glm") |>
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Computational engine: glm 
## 
## Model fit template:
## stats::glm(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     family = stats::poisson)
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.

\emph{However}, the documentation in \code{\link[stats:glm]{stats::glm()}} assumes
that is specific type of case weights are being used:“Non-NULL weights
can be used to indicate that different observations have different
dispersions (with the values in weights being inversely proportional to
the dispersions); or equivalently, when the elements of weights are
positive integers \code{w_i}, that each response \code{y_i} is the mean of \code{w_i}
unit-weight observations. For a binomial GLM prior weights are used to
give the number of trials when the response is the proportion of
successes: they would rarely be used for a Poisson GLM.”

If frequency weights are being used in your application, the
\code{\link[=glm_grouped]{glm_grouped()}} model (and corresponding engine) may be
more appropriate.
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("poisson_reg_predict") |>
  dplyr::filter(engine == "glm") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 2 x 2
##   mode       type   
##   <chr>      <chr>  
## 1 regression numeric
## 2 regression raw
}\if{html}{\out{</div>}}
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}
}
\keyword{internal}
