% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pammtools.R
\docType{package}
\name{pammtools}
\alias{pammtools-package}
\alias{pammtools}
\title{pammtools: Piece-wise exponential Additive Mixed Modeling tools.}
\description{
\code{pammtools} provides functions and utilities that facilitate fitting
Piece-wise Exponential Additive Mixed Models (PAMMs), including data
transformation and other convenience functions for pre- and post-processing
as well as plotting.
}
\details{
The best way to get an overview of the functionality provided and how to
fit PAMMs is to view the vignettes
available at \url{https://adibender.github.io/pammtools/articles/}.
A summary of the vignettes' content is given below:

\itemize{
\item \href{https://adibender.github.io/pammtools/articles/basics.html}{basics}:
Introduction to PAMMs and basic modeling.
\item \href{https://adibender.github.io/pammtools/articles/baseline.html}{baseline}:
Shows how to estimate and visualize baseline model (without covariates) and
comparison to respective Cox-PH model.
\item \href{https://adibender.github.io/pammtools/articles/convenience.html}{convenience}:
Convenience functions for post-processing and plotting PAMMs.
\item \href{https://adibender.github.io/pammtools/articles/data-transformation.html}{data-transformation}:
Transforming data into a format suitable to fit PAMMs.
\item \href{https://adibender.github.io/pammtools/articles/frailty.html}{frailty}:
Specifying "frailty" terms, i.e., random effects for PAMMs.
\item \href{https://adibender.github.io/pammtools/articles/splines.html}{splines}:
Specifying spline smooth terms for PAMMs.
\item \href{https://adibender.github.io/pammtools/articles/strata.html}{strata}:
Specifying stratified models in which each level of a grouping variable has a
different baseline hazard.
\item \href{https://adibender.github.io/pammtools/articles/tdcovar.html}{tdcovar}:
Dealing with time-dependent covariates.
\item \href{https://adibender.github.io/pammtools/articles/tveffects.html}{tveffects}:
Specifying time-varying effects.
\item \href{https://adibender.github.io/pammtools/articles/left-truncation.html}{left-truncation}:
Estimation for left-truncated data.
\item \href{https://adibender.github.io/pammtools/articles/competing-risks.html}{competing-risks}:
Competing risks analysis.
}
}
\references{
Bender, Andreas, Andreas Groll, and Fabian Scheipl. 2018.
“A Generalized Additive Model Approach to Time-to-Event Analysis”
Statistical Modelling, February. https://doi.org/10.1177/1471082X17748083.

Bender, Andreas, Fabian Scheipl, Wolfgang Hartl, Andrew G. Day, and Helmut Küchenhoff. 2019.
“Penalized Estimation of Complex, Non-Linear Exposure-Lag-Response Associations.”
Biostatistics 20 (2): 315–31. https://doi.org/10.1093/biostatistics/kxy003.

Bender, Andreas, and Fabian Scheipl. 2018.
“pammtools: Piece-Wise Exponential Additive Mixed Modeling Tools.”
ArXiv:1806.01042 Stat, June. https://arxiv.org/abs/1806.01042.
Ramjith J, Bender A, Roes KCB, Jonker MA. Recurrent events analysis
with piece-wise exponential additive mixed models. 2022. Statistical
Modelling., 2022
}
\seealso{
Useful links:
\itemize{
  \item \url{https://adibender.github.io/pammtools/}
  \item Report bugs at \url{https://github.com/adibender/pammtools/issues}
}

}
\author{
\strong{Maintainer}: Andreas Bender \email{andreas.bender@stat.uni-muenchen.de} (\href{https://orcid.org/0000-0001-5628-8611}{ORCID})

Authors:
\itemize{
  \item Fabian Scheipl \email{fabian.scheipl@stat.uni-muenchen.de} (\href{https://orcid.org/0000-0001-8172-3603}{ORCID})
  \item Johannes Piller \email{johannes.piller@lmu.de} (\href{https://orcid.org/0009-0008-3010-9556}{ORCID})
  \item Philipp Kopper \email{philipp.kopper@stat.uni-muenchen.de} (\href{https://orcid.org/0000-0002-5037-7135}{ORCID})
}

Other contributors:
\itemize{
  \item Lukas Burk \email{burk@leibniz-bips.de} (\href{https://orcid.org/0000-0001-7528-3795}{ORCID}) [contributor]
}

}
\keyword{internal}
